# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 7
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR7_strategy.txt
# LLM Suggested Fallback: Not Provided

def velvet_illusion(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    if current_round == 1:
        return "C"
    
    if current_round <= 3:
        if opp_history[-1] == "D":
            return "D"
        return "C"
    
    if current_round <= 7:
        if "return 'C'" in opponent_program_code and "random" not in opponent_program_code:
            if current_round % 2 == 0:
                return "D"
        if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
            return "D"
        if random.random() < 0.25:
            return "C"
        return opp_history[-1]
    
    if current_round >= 8:
        if sum(1 for move in opp_history[-5:] if move == "D") > 2:
            return "D"
        else:
            if current_round % 2 == 0:
                return "C"
            else:
                return "D"
    
    return "C"